;*******************************
;*    DEMONTRATION PROGRAM 7   *
;*           SCAN KEY          *
;*******************************
;
            ORG    8000H
U25PA       EQU    0E0B0H
U25PB       EQU    0E0B1H
U25PC       EQU    0E0B2H
U25CTRL     EQU    0E0B3H
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
U21PA       EQU    0E0B8H
U21PB       EQU    0E0B9H
U21PC       EQU    0E0BAH
U21CTRL     EQU    0E0BBH
DA_PORT     EQU    U21PA           ;D to A Port
SEG_PORT    EQU    U21PB
SCAN_KYDP   EQU    27H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
TWO_IN_ONE  EQU    2EH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
GET_2KEY    EQU    12H             ;   "     "
HEX_2_SEG   EQU    15H
SYSCALL     EQU    0030H
KEY_STAT    EQU    10H             ;Bit addressable (22.0 h)
KEY_BUF     EQU    23H

CP3DEM7:    MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A

            MOV    DPTR,#U25CTRL
            MOV    A,#88H
            MOVX   @DPTR,A

            MOV    DPTR,#U21CTRL
            MOV    A,#80H
            MOVX   @DPTR,A

            MOV    PSW,#0
            CLR    KEY_STAT
            LCALL  CLR_SCR
            MOV    DPTR,#DISBUF+5
            MOV    A,#3CH
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A

START:      LCALL  SCANKEY
            CJNE   A,#0FFH,STR1
            LCALL  DISPLAY
            SJMP   START
STR1:       MOV    KEY_BUF,A
            MOV    B,A
            MOV    A,#HEX_2_SEG
            LCALL  SYSCALL
            MOV    DPTR,#SEG_PORT  ;Display key code
            MOVX   @DPTR,A         ;on 7-segment

            MOV    A,KEY_BUF
            MOV    DPTR,#KEY_DSP
            MOVC   A,@A+DPTR       ;Get key word
            PUSH   ACC

            MOV    DPTR,#DISBUF+5
            ANL    A,#0FH
            MOV    R0,A
            MOVC   A,@A+DPTR       ;Get display buffer
            MOV    B,A
STR2:       POP    ACC             ;Get key word
            CLR    CY
            RRC    A
            CLR    CY
            RRC    A
            XRL    A,B             ;Toggle bit
            MOV    B,A
            MOV    A,R0
            ADD    A,DPL
            MOV    DPL,A
            JNC    STR3
            INC    DPTR
STR3:       MOV    A,B
            MOVX   @DPTR,A
            SJMP   START

;*******************************
;*     Scan key                *
;*Input     : -                *
;*Output    : ACC=Key pressed, *
;*            otherwise = 0FFH *
;*Register  : R2,R3,ACC,DPTR   *
;*******************************
;
SCANKEY:    MOV    R2,#1EH
            MOV    R3,#0
            MOV    DPTR,#U25PC
SCK0:       MOV    A,R2
            MOVX   @DPTR,A            ;Out column
            NOP
            MOVX   A,@DPTR            ;In row
            ANL    A,#70H
            CJNE   A,#70H,SCK1
            INC    R3
            SETB   CY
            MOV    A,R2
            RLC    A
            MOV    R2,A
            MOV    A,#0FFH
            JNC    SCK0
            CLR    KEY_STAT
            SJMP   OUT_SCANK
SCK1:       JB     ACC.4,SCK2
            MOV    DPTR,#ROW0
            SJMP   KEY_CODE
SCK2:       JB     ACC.5,SCK3
            MOV    DPTR,#ROW1
            SJMP   KEY_CODE
SCK3:       MOV    DPTR,#ROW2
KEY_CODE:   MOV    A,DPL
            ADD    A,R3
            MOV    DPL,A
            JNC    KY_CD1
            INC    DPH
KY_CD1:     MOVX   A,@DPTR
            JNB    KEY_STAT,KY_CD2
            MOV    A,#0FFH
            SJMP   OUT_SCANK
KY_CD2:     SETB   KEY_STAT
OUT_SCANK:  RET

            ;*  Key code table
ROW0:       DB     0,1,2,3
ROW1:       DB     4,5,6,7
ROW2:       DB     8,9,0AH,0BH

            ;* Toggle bit table
            ;* Hight nibble of data is bit mask
            ;* low nibble of data is row on display
KEY_DSP:    DB     82H,42H,22H,12H     ;"0,1,2,3"
            DB     81H,41H,21H,11H     ;"4,5,6,7"
            DB     80H,40H,20H,10H     ;"8,9,A,B"

;*********************************
;*        DISPLAY ROUTINE        *
;*********************************
;
DISPLAY:    PUSH   PSW
            SETB   RS0             ;Select bank 1
            MOV    DPTR,#U25PA
            MOV    P2,DPH
            MOV    R0,DPL         ;P2:R0 = Data
            INC    DPTR
            MOV    R1,DPL         ;P2:R1 = Row scan
            MOV    DPTR,#DISBUF
            MOV    R2,#1
            MOV    R3,#8

DP2:        CLR    A
            MOVX   @R1,A          ; Clear scan row
            MOVX   A,@DPTR        ; Read Data from buffer
            INC    DPTR           ; Bump Pointer
            MOVX   @R0,A          ; Write data to port A
            MOV    A,R2
            MOVX   @R1,A
            RL     A
            MOV    R2,A
            LCALL  ROW_DLY
            DJNZ   R3,DP2
            CLR    A
            MOVX   @R1,A
OUT_DSP:    POP    PSW
            RET

ROW_DLY:    PUSH   ACC
            PUSH   B
            MOV    B,#10
RD1:        DEC    B
            MOV    A,B
            JNZ    RD1
            POP    B
            POP    ACC
            RET

;*******************************
;*        CLEAR SCREEN         *
;*******************************
CLR_SCR:    PUSH   DPL
            PUSH   DPH
            MOV    DPTR,#DISBUF
            MOV    R0,#8
F1:         CLR    A
            MOVX   @DPTR,A
            INC    DPTR
            DJNZ   R0,F1
            POP    DPH
            POP    DPL
            RET

            ;* Ram working arear
DISBUF:     DS      8

            END



